#include "General.h"
#include "GameSpy_Support.h"
#include "GameSpyClass.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

int GameSpy::ListenSocket = 0;
struct sockaddr_in GameSpy::ClientAddress, GameSpy::ServerAddress, GameSpy::MasterAddress1, GameSpy::MasterAddress2;
unsigned short GameSpy::QueryPort = 0;
time_t GameSpy::LastHeartbeat = 0;
int GameSpy::ClientAddressLength;
int GameSpy::PlayerJoinTime[127];

void GameSpy::StartUp()
{
	char Buf[32];										
	InitListen(Long2IP((unsigned int)The_Game()->Get_Ip_Address(), Buf, 32), GameSpy_Support::ListenPort);
	Console_Output("[GameSpy Support SSGM 4.0 Plugin] Loaded on %s:%d\n", Long2IP((unsigned int)The_Game()->Get_Ip_Address(), Buf, 32),GameSpy_Support::ListenPort);
}

int GameSpy::InitListen(const char *IP, unsigned short Port)
{
	QueryPort = Port;
	struct hostent *HostInfo;
	HostInfo = gethostbyname("92.242.144.2"); //");
	if (HostInfo != NULL)
	{
		MasterAddress1.sin_family = HostInfo->h_addrtype;
		memcpy((char *) &MasterAddress1.sin_addr.s_addr, HostInfo->h_addr_list[0], HostInfo->h_length);
		MasterAddress1.sin_port = htons(27900);
	}
	HostInfo = gethostbyname("master.gamespy.com");
	if (HostInfo != NULL)
	{
		MasterAddress2.sin_family = HostInfo->h_addrtype;
		memcpy((char *) &MasterAddress2.sin_addr.s_addr, HostInfo->h_addr_list[0], HostInfo->h_length);
		MasterAddress2.sin_port = htons(27900);
	}
	ListenSocket = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP);
	int vals = 0;
	setsockopt(ListenSocket, IPPROTO_IP, IP_DONTFRAGMENT, (const char*) &vals, sizeof(vals));
	if (ListenSocket < 0)
	{
		Console_Output("[GameSpy Support SSGM Plugin] Error: Cannot create listen socket.\n");
	}
	HostInfo = gethostbyname(IP);
	if (HostInfo != NULL)
	{
		ServerAddress.sin_family = AF_INET;
		memcpy((char *) &ServerAddress.sin_addr.s_addr, HostInfo->h_addr_list[0], HostInfo->h_length);
		ServerAddress.sin_port = htons(Port);

		if (bind(ListenSocket,(struct sockaddr *) &ServerAddress,sizeof(ServerAddress)) < 0)
		{
			Console_Output("[GameSpy Support SSGM Plugin] Error: Cannot bind listen port.\n");
		}
		listen(ListenSocket, 5);
		CreateThread(NULL, NULL, ListenThread, NULL, NULL, NULL);
	}
	return 1;
}

DWORD WINAPI GameSpy::ListenThread(LPVOID param)
{
	char Get[1024];
	char Send[4096];
	char Tmp[256];
	int x = 0;

	DoHeartBeat();

	for(;;)
	{
		x++;
		ClientAddressLength = sizeof(ClientAddress);
		memset(Get, 0x0, 1024);
		memset(Send, 0x0, 4096);
		memset(Tmp, 0x0, 256);

		int retrecv = recvfrom(ListenSocket, Get, 1023, 0,(struct sockaddr *) &ClientAddress,&ClientAddressLength);
		if (retrecv == SOCKET_ERROR)
		{ 
			if (retrecv == 0)
			{
				Console_Output("[GameSpy Support SSGM Plugin] Error: Received 0 bytes of packets. Possible connection error.\n");
				continue;
			}
			if ( (!strstr(Get,"\\echo\\\\final\\\\queryid\\")!= 0 ) )  // some servers get weird packets sent to them by gamespy
			{
				continue;
			}
			int Error = WSAGetLastError();
			Console_Output("[GameSpy Support SSGM Plugin] Error: Input/Ouput failure.\n");
			char Derp[256];
			sprintf(Derp, "Error code: %d. Buffer size: %d\n", Error, (int)strlen(Get));
			Console_Output(Derp);

			/* FILE* fp;
			fp = fopen ("gamespy_plugin_debug.txt","a+");
			fprintf (fp, "Packet content: %s\n",Get);
			fclose (fp); */

		}
		if (!strcmp(Get,"\\basic\\"))
		{
			char *Data = GetBasic();
			sprintf(Send,"%s\\final\\\\queryid\\%d.1",Data,x);
			delete []Data;
		}
		else if (!strcmp(Get,"\\info\\"))
		{
			char *Data = GetInfo();
			sprintf(Send,"%s\\final\\\\queryid\\%d.1",Data,x);
			delete []Data;
		}
		else if (!strcmp(Get,"\\rules\\"))
		{
			char *Data = GetRules();
			sprintf(Send,"%s\\final\\\\queryid\\%d.1",Data,x);
			delete []Data;
		}
		else if (!strcmp(Get,"\\players\\"))
		{
			char *Data = GetPlayers(Send,&x);
			sprintf(Send,"%s\\queryid\\%d.1",Data,x);
			delete []Data;
		}
		else if (!strcmp(Get,"\\status\\"))
		{
			char *Data = GetBasic();
			sprintf(Send,"%s",Data);
			delete []Data;
			Data = GetInfo();
			sprintf(Send,"%s%s",Send,Data);
			delete []Data;
			Data = GetRules();
			sprintf(Send,"%s%s",Send,Data);
			delete []Data;
			Data = GetPlayers(Send,&x);
			delete []Data;
			continue;
		}
		else if (sscanf(Get,"\\echo\\%[^\r\n\0]",Tmp))
		{
			sprintf(Send,"\\echo\\%s\\final\\\\queryid\\%d.1",Tmp,x);
		}
		else
		{
			Console_Output("[GameSpy Support SSGM Plugin] Error: Invalid packet \"%s\" found, ignoring...\n", Get);
			continue;
		}

		if (strlen(Send) > 0)
		{
			if (sendto(ListenSocket, Send, strlen(Send) + 1, 0,(struct sockaddr *) &ClientAddress,sizeof(ClientAddress)) < 0)
			{
				Console_Output("[GameSpy Support SSGM Plugin] Error: Data send failure.\n");
				break;
			}
		}
		Sleep(10);
	}
	return 0;
}

char *GameSpy::GetBasic()
{
	char *Data = new char[4096];
	memset(Data, 0x0, 4096);
	sprintf(Data,"\\gamename\\ccrenegade\\gamever\\838");
	return Data;
}

char *GameSpy::GetInfo()
{
	char *Data = new char[4096];
	memset(Data, 0x0, 4096);

	if (GameSpy_Support::CustomGameTitle == "0")
	{
		sprintf(Data, "%s\\hostname\\\%S", Data, GameSpy_Support::GameTitle.Peek_Buffer());	
	}
	else
	{
		sprintf(Data, "%s\\hostname\\\%s", Data, GameSpy_Support::CustomGameTitle.Peek_Buffer());
	}

	sprintf(Data, "%s\\hostport\\%d", Data, The_Game()->Get_Port());
	sprintf(Data, "%s\\mapname\\%s", Data, The_Game()->getMapBaseName().Peek_Buffer());

	if (GameSpy_Support::ShowGameMode)
	{
		sprintf(Data, "%s\\gametype\\%s", Data, GameSpy_Support::GameMode.Peek_Buffer());
	} 
	sprintf(Data, "%s\\numplayers\\%d", Data, The_Game()->Get_Current_Players());
	sprintf(Data, "%s\\maxplayers\\%d", Data, GameSpy_Support::MaxPlayers ? GameSpy_Support::MaxPlayers : The_Game()->Get_Max_Players());
	
	sprintf(Data, "%s\\password\\%d", Data, The_Game()->Is_Passworded());
	return Data;
}

char *GameSpy::GetRules()
{
	char *Data = new char[8192];
		
	char TimeStr[128];
	FormatTime((time_t)(int)The_Game()->Get_Time_Remaining_Seconds(), "%H:%M:%S", TimeStr, 256);

	memset(Data, 0x0, 8192);
	sprintf(Data,"\\DED\\1");

	if (GameSpy_Support::ShowDriverGunner)
	{
		sprintf(Data,"%s\\Driver Gunner\\%s",Data,The_Game()->Driver_Is_Always_Gunner() ? "On" : "Off");
	}
	if (GameSpy_Support::ShowTeamChanging)
	{
		sprintf(Data,"%s\\Team Changing\\%s",Data,The_Game()->Is_Team_Changing_Allowed() ? "On" : "Off");
	}
	if (GameSpy_Support::ShowFriendlyFire)
	{
		sprintf(Data,"%s\\Friendly Fire\\%s",Data,The_Game()->Is_Friendly_Fire_Permitted() ? "On" : "Off");
	}
	if (GameSpy_Support::ShowCredits)
	{
		sprintf(Data,"%s\\Start Credits\\%d",Data,The_Cnc_Game()->StartingCredits);
	}
	if (GameSpy_Support::ShowTimeLeft)
	{
		sprintf(Data,"%s\\TimeLeft\\%s",Data, TimeStr);
	}
	if (GameSpy_Support::ShowPedestal)
	{
		sprintf(Data,"%s\\Pedestal Beacon\\%s",Data,The_Cnc_Game()->BeaconPlacementEndsGame ? "On" : "Off");
	}
	

	for( int i = 0; i < GameSpy_Support::ExtraStringList.Count(); i++)
	{

			sprintf(Data, "%s\\%s", Data, GameSpy_Support::ExtraStringList[i]);
	}
	if (GameSpy_Support::ShowRotation)
	{
		for(int i = 0;; i++)
		{
			const char *x = Get_Map(i);
			if( x != NULL)
			{
				sprintf(Data,"%s\\Map%02d\\%s", Data, i, x);
			}
			else
			{
				break;
			}
		}
	}
	return Data;
}

char *GameSpy::GetPlayers(const char *Send, int *x)
{
	char *Data = new char[4096];
	memset(Data, 0x0, 4096);
	sprintf(Data,"%s",Send);

	char queryid[128];
	char final[128];
	sprintf(queryid, "\\queryid\\%d.1", x);
	sprintf(final, "\\final\\");
	int i = 0;

	strncat(Data, final, strlen(final)+1);
	sendto(ListenSocket, Data, strlen(Data) +1, 0,(struct sockaddr *) &ClientAddress,sizeof(ClientAddress));
	memset(Data, 0x0, 4096);

	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		if (strlen(Data) > 1000)
		{
			strcat(Data, queryid);
			sendto(ListenSocket, Data, strlen(Data) + 1, 0,(struct sockaddr *) &ClientAddress,sizeof(ClientAddress));
			memset(Data,0x0, 4096);
		}

		cPlayer *p = PlayerIter->Data();
		if (p->IsActive)
		{
			char TimeStr[256];
			if ( GameSpy_Support::UseTotalPlayerTime )
			{
				FormatTime(time(NULL) - GameSpy::GetJoinTime(p->PlayerId), "%H:%M:%S", TimeStr, 256);
			}
			else
			{
				FormatTime((time_t)p->GameTime, "%H:%M:%S", TimeStr, 256);
			}
			
			sprintf(Data,"%s\\player_%d\\%ls\\score_%d\\%d\\kills_%d\\%d\\deaths_%d\\%d\\time_%d\\%s\\ping_%d\\%d\\team_%d\\%s",Data,i,p->PlayerName,i,(int)Get_Score(p->PlayerId),i, (int)Get_Kills(p->PlayerId),i,(int)Get_Deaths(p->PlayerId),i,TimeStr,i,Get_Ping(p->PlayerId),i,Get_Team_Name(Get_Team(p->PlayerId)));
			i++;
		}
	}
	strcat(Data, queryid);
	sendto(ListenSocket, Data, strlen(Data) + 1, 0,(struct sockaddr *) &ClientAddress,sizeof(ClientAddress));

	return Data;
}

void GameSpy::DoHeartBeat()
{
	char Send[4096];
	memset(Send, 0x0, 4096);
	sprintf(Send,"\\heartbeat\\%d\\gamename\\ccrenegade",GameSpy_Support::ListenPort);

	if (sendto(ListenSocket, Send, strlen(Send) + 1, 0,(struct sockaddr *) &MasterAddress1,sizeof(MasterAddress1)) < 0)
	{
		printf("[GameSpy Support SSGM Plugin] Error: Heartbeat failure.\n");
	}
	if (sendto(ListenSocket, Send, strlen(Send) + 1, 0,(struct sockaddr *) &MasterAddress2,sizeof(MasterAddress2)) < 0)
	{
		printf("[GameSpy Support SSGM Plugin] Error: Heartbeat failure.\n");
	}
}

const char *Long2IP(unsigned int longip, char *buffer, int size)
{
	sprintf_s(buffer, size, "%d.%d.%d.%d", 0xFF & longip, (0xFF00 & longip) >> 8, (0xFF0000 & longip) >> 16, ((0xFF000000 & longip) >> 24));
	return buffer;
}

void FormatTime(time_t t, const char *Format, char *buffer, int Length)
{
	tm* time = new tm;
	memset((void*)time, 0x0, sizeof(time));
	time->tm_hour = t / 3600;
	time->tm_min  = (t % 3600) / 60;
	time->tm_sec = t % 60;
	strftime(buffer, Length, Format, time);
	delete time;
}

void GameSpy::SetJoinTime(int ID, int value)
{
	GameSpy::PlayerJoinTime[ID] = value;
}

int GameSpy::GetJoinTime(int ID)
{
	return GameSpy::PlayerJoinTime[ID];
}